# Mega Man 2

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a
config file.

## What does randomization do to this game?

Weapons received from Robot Masters, access to each individual stage, and Items from Dr. Light are randomized
into the multiworld. Access to the Wily Stages is locked behind receiving Item 1, 2, and 3. The game is completed when 
viewing the ending sequence after defeating the Alien.

## What Mega Man 2 items can appear in other players' worlds?
- Robot Master weapons
- Robot Master Access Codes (stage access)
- Items 1/2/3
- 1-Ups
- E-Tanks
- Health Energy (L)
- Weapon Energy (L)

## What is considered a location check in Mega Man 2?
- The defeat of a Robot Master or Wily Boss
- Receiving a weapon or item from Dr. Light
- Optionally, 1-Ups and E-Tanks present within stages
- Optionally, Weapon and Health Energy pickups present within stages

## When the player receives an item, what happens?
A sound effect will play based on the type of item received, and the effects of the item will be immediately applied, 
such as unlocking the use of a weapon mid-stage. If the effects of the item cannot be fully applied (such as receiving 
Health Energy while at full health), the leftover amount is withheld until it can be applied.

## What is EnergyLink?
EnergyLink is an energy storage supported by certain games that is shared across all worlds in a multiworld. In Mega Man
 2, when enabled, drops from enemies are not applied directly to Mega Man and are instead deposited into the EnergyLink.
Half of the energy that would be gained is lost upon transfer to the EnergyLink. 

Energy from the EnergyLink storage can be converted into health, weapon energy, and lives at different conversion rates.
You can find out how much of each type you can pull using the `/pool` command in the client. Additionally, you can have it 
automatically pull from the EnergyLink storage to keep Mega Man healed using the `/autoheal` command in the client. 
Finally, you can use the `/request` command to request a certain type of energy from the storage.

## Plando Palettes
The palette shuffle option supports specifying a specific palette for a given weapon/Robot Master. The format for doing 
so is `Character-Color1|Color2;Option`. Character is the individual that this should apply to, and can only be one of 
the following:
- Mega Buster
- Atomic Fire
- Air Shooter
- Leaf Shield
- Bubble Lead
- Quick Boomerang
- Time Stopper
- Metal Blade
- Crash Bomber
- Item 1
- Item 2
- Item 3
- Heat Man
- Air Man
- Wood Man
- Bubble Man
- Quick Man
- Flash Man
- Metal Man
- Crash Man

Colors attempt to map a list of HTML-defined colors to what the NES can render. A full list of applicable colors can be
found [here](https://github.com/MultiworldGG/MultiworldGG/blob/main/worlds/mm2/color.py#L11). Alternatively, colors can 
be supplied directly using `$xx` format. A full list of NES colors can be found [here](https://www.nesdev.org/wiki/PPU_palettes#2C02).

You can also pass only one color (such as `Mega Buster-Red`) and it will interpret a second color based off of the color
given. Additionally, passing only colors (such as `Red|Blue`) and not any specific boss/weapon will apply that color to 
all weapons/bosses that did not have a prior color specified.

The option is the method to be used to set the palettes of the remaining bosses/weapons, and will not overwrite any 
plando placements.

## Plando Weaknesses
Plando Weaknesses allows you to override the amount of damage a boss should take from a given weapon, ignoring prior 
weaknesses generated by strict/random weakness options. Formatting for this is as follows:
```yaml
plando_weakness:
  Air Man:
    Atomic Fire: 0
    Bubble Lead: 4
```
This would cause Air Man to take 4 damage from Bubble Lead, and 0 from Atomic Fire.

Note: it is possible that plando weakness is not be respected should the plando create a situation in which the game 
becomes impossible to complete. In this situation, the damage would be boosted to the minimum required to defeat the 
Robot Master.


## Unique Local Commands
- `/pool` Only present with EnergyLink, prints the max amount of each type of request that could be fulfilled.
- `/autoheal` Only present with EnergyLink, will automatically drain energy from the EnergyLink in order to 
restore Mega Man's health.
- `/request <amount> <type>` Only present with EnergyLink, sends a request of a certain type of energy to be pulled from
the EnergyLink. Types are as follows:
  - `HP` Health
  - `AF` Atomic Fire
  - `AS` Air Shooter
  - `LS` Leaf Shield
  - `BL` Bubble Lead
  - `QB` Quick Boomerang
  - `TS` Time Stopper
  - `MB` Metal Blade
  - `CB` Crash Bomber
  - `I1` Item 1
  - `I2` Item 2
  - `I3` Item 3
  - `1U` Lives